/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.aladin.Aladin;
import cds.aladin.HealpixProgen;
import cds.aladin.HealpixProgenItem;
import cds.aladin.SourceFootprint;
import cds.aladin.stc.STCObj;
import cds.allsky.Action;
import cds.allsky.Builder;
import cds.allsky.Context;
import cds.moc.Moc;
import cds.moc.SMoc;
import cds.moc.TMoc;
import cds.tools.pixtools.Util;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.List;

public class BuilderSMoc
extends Builder {
    protected int hipsOrder;
    protected int spaceOrder;
    protected int timeOrder;
    protected long maxSize = -1L;
    protected String ruleSize = null;
    protected long lastAdjustTime = -1L;
    protected int statNbFile;
    protected long startTime;
    protected long totalTime;
    private SMoc smoc = null;

    public BuilderSMoc(Context context) {
        super(context);
    }

    @Override
    public Action getAction() {
        return Action.SMOC;
    }

    @Override
    public void run() throws Exception {
        this.build();
    }

    @Override
    public void validateContext() throws Exception {
        this.validateOutput();
        this.validateIndex();
        this.hipsOrder = this.context.getOrder();
        if (this.hipsOrder == -1) {
            this.hipsOrder = Util.getMaxOrderByPath(this.context.getHpxFinderPath());
            if (this.hipsOrder == -1) {
                throw new Exception("HpxFinder seems to be not yet ready ! (order=-1)");
            }
            this.context.info("HiPS order retrieved from HpxFinder => " + this.hipsOrder);
            this.context.setOrder(this.hipsOrder);
        }
        this.context.mocIndex = null;
        this.context.initRegion();
        if (this.context.getMocOrder() != -1) {
            this.spaceOrder = this.context.getMocOrder();
            int tileOrder = this.context.getTileOrder();
            if (this.spaceOrder > tileOrder + this.hipsOrder) {
                this.context.warning("Too high mocOrder (" + this.spaceOrder + ") => assume " + (tileOrder + this.hipsOrder));
                this.spaceOrder = tileOrder + this.hipsOrder;
            }
        } else {
            this.spaceOrder = this.hipsOrder;
        }
        this.timeOrder = this.context.getTMocOrder();
        if (this.timeOrder == -1) {
            this.timeOrder = 41;
        }
        this.maxSize = this.context.getMocMaxSize();
        this.ruleSize = this.context.getMocRuleSize();
    }

    @Override
    public void showStatistics() {
        this.context.showJpgStat(this.statNbFile, this.totalTime, 0, 0);
        this.info();
    }

    @Override
    public void build() throws Exception {
        this.initStat();
        String hpxFinder = this.context.getHpxFinderPath();
        SMoc mocFinder = new SMoc();
        mocFinder.read(hpxFinder + Util.FS + "Moc.fits");
        mocFinder.setMocOrder(this.hipsOrder);
        long progress = 0L;
        this.context.setProgressMax(mocFinder.getNbValues());
        this.cleanIt();
        this.initIt();
        this.info();
        int maxCache = 200;
        ArrayDeque<String> cache = new ArrayDeque<String>(maxCache);
        Iterator<Long> it = mocFinder.valIterator();
        while (it.hasNext()) {
            long npix = it.next();
            String file = Util.getFilePath(hpxFinder, this.hipsOrder, npix);
            HealpixProgen out = this.createLeave(file);
            if (out == null) {
                this.context.warning("Missing HpxFinder tile " + this.hipsOrder + "/" + npix + " => ignored (" + file + ")");
                continue;
            }
            for (String key : out) {
                String json = ((HealpixProgenItem)out.get(key)).getJson();
                try {
                    String path = cds.tools.Util.extractJSON("path", json);
                    if (cache.contains(path)) continue;
                    if (cache.size() > maxCache) {
                        cache.removeFirst();
                    }
                    cache.add(path);
                    TMoc tmoc = this.getTMoc(this.timeOrder, json);
                    SMoc smoc = this.getSMoc(this.spaceOrder, json);
                    this.addIt(tmoc, smoc);
                }
                catch (MocParsingException e1) {
                    throw new Exception();
                }
                catch (Exception e) {
                    this.context.warning("parsing error => " + json);
                }
            }
            this.context.setProgress(progress++);
        }
        this.writeIt();
    }

    protected boolean mustAdjustSize(Moc m, boolean force) {
        if (force) {
            m.flush();
        }
        return m.bufferSize() == 0;
    }

    protected void reduction(Moc m) throws Exception {
        m.reduction(this.maxSize);
    }

    protected void adjustSize(Moc m, boolean force) throws Exception {
        if (this.maxSize == -1L) {
            return;
        }
        if (!this.mustAdjustSize(m, force)) {
            return;
        }
        if (m.getMem() <= this.maxSize) {
            return;
        }
        this.reduction(m);
        int o = m.getTimeOrder();
        if (o != -1) {
            this.timeOrder = o;
        }
        if ((o = m.getSpaceOrder()) != -1) {
            this.spaceOrder = o;
        }
    }

    protected void initIt() throws Exception {
        this.smoc = new SMoc(this.spaceOrder);
        this.smoc.bufferOn();
    }

    protected void info() {
        String s = this.maxSize > 0L ? " maxSize=" + cds.tools.Util.getUnitDisk(this.maxSize) : "";
        String s1 = this.smoc.getMem() > 0L ? " currentSize=" + cds.tools.Util.getUnitDisk(this.smoc.getMem()) : "";
        this.context.info("SMOC generation (spaceOrder=" + this.smoc.getSpaceOrder() + s + s1 + ")...");
    }

    protected TMoc getTMoc(int order, String json) throws Exception {
        return null;
    }

    protected SMoc getSMoc(int order, String json) throws Exception {
        String stc = cds.tools.Util.extractJSON("stc", json);
        SourceFootprint sf = new SourceFootprint();
        sf.setStcs(Double.NaN, Double.NaN, stc);
        List<STCObj> listStcs = sf.getStcObjects();
        if (listStcs == null) {
            throw new Exception();
        }
        return Aladin.createMocRegion(listStcs, order, true);
    }

    protected void addIt(TMoc tmoc1, SMoc smoc1) throws Exception {
        this.smoc.add(smoc1);
        this.adjustSize(this.smoc, false);
    }

    protected void cleanIt() throws Exception {
        String file = this.context.getOutputPath() + Util.FS + "SMoc.fits";
        new File(file).delete();
    }

    protected void writeIt() throws Exception {
        this.adjustSize(this.smoc, true);
        if (this.smoc.isEmpty()) {
            throw new Exception("Empty MOC => not generated");
        }
        String file = this.context.getOutputPath() + Util.FS + "SMoc.fits";
        this.smoc.write(file);
    }

    protected void initStat() {
        this.statNbFile = 0;
        this.startTime = System.currentTimeMillis();
    }

    protected void updateStat() {
        ++this.statNbFile;
        this.totalTime = System.currentTimeMillis() - this.startTime;
    }

    protected HealpixProgen createLeave(String file) throws Exception {
        File f = new File(file);
        if (!f.exists()) {
            return null;
        }
        HealpixProgen out = new HealpixProgen();
        out.loadStream(new FileInputStream(f));
        this.updateStat();
        return out;
    }

    class MocParsingException
    extends Exception {
        MocParsingException() {
        }
    }
}

